% program to implement the 5th order SCIG-based WECS model
% SI units
clear

% WECS parameters
Rs= 0.0011
Rr= 0.0013
Lm= 2.9936e-3
Ls= 7e-5 + Lm
Lr= 7.5e-5 + Lm
p= 2
ws= 314.2       % for 50 Hz
sgm= 1-Lm^2/Lr/Ls
ro= 1.25
R= 45
i= 100
JHSS= 990       % HSS inertia

vbar= 10;
% give here the steady-state operating point
% ist= [0 0 0 0 0]
ist= [-1442 925.4 31.69 -948.7 157.2]
ombar= ist(5);

% computes wind torque and wind torque parameter values
lam=(ombar/i)*R/vbar;
Cgbar = 0.0061-0.0013*lam+0.0081*lam^2-9.7477*10^(-4)*lam^3-6.5416*10^(-5)*lam^4+1.3027*10^(-5)*lam^5-4.54*10^(-7)*lam^6;
% torque coefficient derived in relation to tip speed
Cgpbar = -0.0013+2*0.0081*lam-3*9.7477*10^(-4)*lam^2-4*6.5416*10^(-5)*lam^3+5*1.3027*10^(-5)*lam^4-6*4.54*10^(-7)*lam^5;
Tbar = 0.5*pi*ro*(R^3)*(vbar^2)*Cgbar;
% torque parameter formula, resulting after some algebra (Relations 3.78 and 2.32)
gam = Cgpbar*lam/Cgbar

% system matrix
A = [...
    -Rs/(Ls*sgm)                       ws+p*ombar*(Lm^2)/(sgm*Ls*Lr)   Lm*Rr/(sgm*Ls*Lr)        p*ombar*Lm/(sgm*Ls)     p*Lm/(sgm*Ls)*(ist(2)*Lm/Lr+ist(4));...
     -(ws+p*ombar*(Lm^2)/(sgm*Ls*Lr))   -Rs/(Ls*sgm)                    -p*ombar*Lm/(sgm*Ls)    Lm*Rr/(sgm*Ls*Lr)       -p*Lm/(sgm*Ls)*(ist(1)*Lm/Lr+ist(3));...
     Lm*Rs/(sgm*Ls*Lr)                  -p*ombar*Lm/(sgm*Lr)            -Rr/(Lr*sgm)            ws-p*ombar/sgm          -p/sgm*(ist(2)*Lm/Lr+ist(4));...
     p*ombar*Lm/(sgm*Lr)                Lm*Rs/(sgm*Ls*Lr)               -ws+p*ombar/sgm         -Rr/(Lr*sgm)            p/sgm*(ist(1)*Lm/Lr+ist(3));...
     -1.5*p*Lm/JHSS*ist(4)                 1.5*p*Lm/JHSS*ist(3)             1.5*p*Lm/JHSS*ist(2)     -1.5*p*Lm/JHSS*ist(1)      Tbar/ombar*gam/(i*JHSS)...
    ];

% pole constellation
E= eig(A)
figure; plot(real(E),imag(E),'xk'); axis([-10 0 -400 400])
