% computes the LQG controller parameters, K1 - on the HF rotational speed, ...
% K2 - on the HF wind torque
% uses the linearzid WECS model with parameters computed in lin_param_comp.m file
% uses quadratic performance index with weighting coefficient "weight"

% input the weighting coefficient
df=num2str(weight);
wind={'Input the weighting coefficient (alfa):'};
tmp=inputdlg(wind,'!',1,{df});
if isempty(tmp)~=1; weight=[str2double(tmp)]; end
if isempty(weight) weight=1; end


% computes linearized system matrices
A=[0 1/JT;gamma/Tw gamma/JT-1/Tw]; % 1/JT
B=[-1/JT; -gamma/JT];
Calf=[2/(2-gamma) -1/(2-gamma)]*sqrt(weight);
D=[0];

% matrices related to the performance index
Q=Calf'*Calf;
RR=[1];
N=[0; 0];

% computes LQG controller [K1, K2]
% to be used rigid_2LPSF_ctrl.mdl file, in block named "2LFSP control"
[K,S,E] = LQR(A,B,Q,RR,N);
K1=K(1)
K2=K(2)
% closed-loop matrix
maty=A-B*K;