% program for computing the predicted low frequency (LF) component of the wind velocity
clear all; clf; clc;
disp('Computing ... please wait... (let us say for 15 seconds).')


% ____________ Averge values for 10 min ___________

load vwind;             % input data in mat-file
                        % first line is time index
wind=v(2,:);            % second line contains the total wind velocity evolution 
ve=v(3,:);              % third line is the LF wind velocity component obtained directly by
                        % low-pass filtering - Chebyshev type II, 2nd order, 0.1 rad/s

N=length(ve);
Te=1; fe=1/Te; df=fe/(N);
f=0:df:df*(N-1);
for i=1:N,
    t(i)=i;
end;

ve1(1)=ve(1); M=1;
ve1=sum(ve(1:M));
for i=1:N-M,
    if mod(i-1,M)==0,    
    ve1=[ve1 sum(ve(i:i+M))];   
 else
 end;
 end; 
 ve1=ve/M;  for i=1:N, xr(1,i)=ve(i); end


% ____________ Initialisations ___________

m=3;            % order of the ARMA filter
n=2*m;          % regressing vector dimension
M=120;          % prediction horizon
lambda=1;       % forgetting factor

% variables initialization - least mean square recursive algorithm 
Cxx=10000*eye(n);
g=zeros(N,n);
p=zeros(N,n);
e=zeros(1,N);
y=zeros(1,N);
yf=zeros(1,N);
y1=zeros(1,N);
tr=zeros(1,N);
z=zeros(1,N);
er(1:N)=z(1,:);


% ____________ Prediction iteration ___________

imax=N-max(n,M);        % iterations superior limit

for i=n+1:imax,         % iterations ...
   x(i-n+1:i)=[xr(i-(1:m))  e(i-(1:m))];    % regressing vector building -
                                            % ... based on the actual input data
   y(1,i)=p(i-1,:)*x(i-n+1:i)';             % prediction computing
   e(1,i)=xr(i+M-1)-y(1,i);                 % prediction error
   yf(1,i)=0.8*yf(1,i-1)+0.2*y(1,i);        % filtered variant
                                            % coefficients adaptation gain computation
   g(i,:)=(1/lambda)*(Cxx*x(i-n+1:i)'/(1+(1/lambda)*x(i-n+1:i)*Cxx*x(i-n+1:i)'))'; 
   p(i,:)=p(i-1,:)+e(1,i)*g(i,:);           % adapting the coeffcients
                                            % adjusting correlation matrix 
   Cxx=(1/lambda)*Cxx-(1/lambda)*g(i,:)'*x(i-n+1:i)*Cxx;                                     
   yp(1,i)=p(i,:)*x(i-n+1:i)';              % filtered output after filter adjustment
   er(i)=xr(1,i+M-1)-yp(1,i);               % a posteriori error
   tr(1,i)=trace(Cxx);                      % correlation matrix trace
end;


% ____________ Results ___________

figure(1);                                  % time series, prediction and error
subplot(211),plot(n+1:imax,xr(n+1:imax)), hold on;
plot(n+1:imax,y(1,n+1:imax),'r');,
title(' Blue- Time series;     Red- Prediction ');
axis([n+1 imax 0 20]); grid; hold off;
subplot(212),plot(n+1:imax,e(n+1:imax),'k');
title(' Error '); axis([n+1 imax -10 10]); hold off; grid;

figure(2);                                  % prediction filter parameters evolution
for j=1:n, plot(n+1:imax,p(n+1:imax,j)), hold on; end;
axis([n+1 imax -5 5]); hold off; grid;
title(' a(j), j=1:n coefficient evolutions ');

figure(3);                                  % prediction filter transfer function computation
num=[p(imax,m+1:2*m)]; den=[1 -p(imax,1:m)];                     
sys1=tf(num,den,Te);
bode(sys1);grid; axis([0.01 5 -60 60]); axis([0.01 5 -360 360]);
title(' Prediction filter frequency characteristics ');   

figure(4);                                  % adapation convergence evolution 
semilogy(0:N-n,tr(n:N)),grid;
title(' Cxx matrix trace ');

ind=std(e(30:imax));                        % error standard deviation

figure(5); axis([ 0 1.8e4 0 14]); grid; hold on;
plot(wind); plot(yp,'r'); plot(ve,'k');
title(' Blue- wind velocity;  Red- predicted LF wind component;  Black- LF wind obtained by LPF');
