% computes the LQG controller parameters, [K1 K2 K3 K4]
% system states are the HF components of:
% LSS speed, HSS speed, coupling internal torque, wind torque
% uses the linearzid WECS model with parameters computed in linf_param_comp.m file
% uses quadratic performance index with weighting coefficient "weight"

% input the weighting coefficient
df=num2str(weight);
wind={'Input the weighting coefficient (alfa):'};
tmp=inputdlg(wind,'!',1,{df});
if isempty(tmp)~=1; weight=[str2double(tmp)]; end
if isempty(weight) weight=1; end

% computes linearized system matrices
A=[0 0 -1/JT 1/JT; 0 0 1/JG 0; KA -KA -Bs*(1/JB+1/Jg) Bs/JB; gam/Tw 0 -gam/JT gam/JT-1/Tw]; 
B=[0; -1/JG; Bs/Jg; 0];
C=[2/(2-gam) 0 0 -1/(2-gam)];
D=[0];

% matrices related to the performance index
%________________________
Calf=C*sqrt(weight);
RR=[1];
M=[0 0 0 1];        
Q=Calf'*Calf+M'*M;
N=M';
%________________________


% computes LQG controller [K1 K2 K3 K4]
% to be used flexible_2LPSF_ctrl.mdl file, in block named
% "2LFSP control" -> "controller /HFL"
[K,S,E] = LQR(A,B,Q,RR,N);
K1=K(1)
K2=K(2)
K3=K(3)
K4=K(4)
% closed-loop matrix
maty=A-B*K;