% data file for flexible_2LFSP_ctrl.mdl application
% SI units
clear all

% load wind velocity sequences:     % tv   - time index
                                    % vnt  - total wind velocity sequence
                                    % vflt - low-pass filtered wind 
                                    % vprd - predicted wind velocity
load vinti
tv=tv'; vnt=vnt'; vprd=vprd';

% aerodynamic parameters 
ro= 1.25, Lt=150,          % air density, turbulence length of the site 
R= 2.5,                    % blade length
cp_m= 0.47, lam_opt= 7     % maximum values of power coefficient, tip speed ratio 
tC_opt= cp_m/lam_opt       % and torque coefficient
Jwt= 3.6,                  % rotor inertia 
sT= 0                      % static (or supplimentary) component torque

% mech. transmission parameters
i=6, eta=0.95              % multiplication ratio and efficiency
Ks =75, Bs =0.5            % stiffness and damping
                           % no supplimentary inertias of transmission

% SCIG parameters
% 220V / 50Hz
% 157 rad/s
% 6kW
% ____________________________
Rs = 1.265, Rr = 1.430      % stator & rotor resistance, inductance etc
Ls = 0.1452, Lr = 0.1452
Lm = 0.1397, p = 2
sgm=1-Lm^2/Lr/Ls, Tr=Lr/Rr
% not used in this application
emTmax = 50                 % maximum torque value
Jg = 0.05                   % IM inertia

% control law parameters
tg  = 0.02                  % electromagnetic subsystem (EMS) time constant                   

                            % default initial parameters
wind_st=7.5
weight=10



disp('Parameters loaded!')
