% data file for sliding_mode_ctrl.mdl application
% SI units
clear all

% loading precomputed wind sequece from 'w_velocity.mat'
load w_velocity, tt=1:length(wind_velocity); tt=tt'; wind_velocity=wind_velocity';

% aerodynamic parameters 
ro= 1.25, R= 2.5
cp_m= 0.47, lam_opt= 7      % maximum values of power coefficient, tip speed ratio 
tC_opt= cp_m/lam_opt        % and torque coefficient
Jwt= 3,                     % rotor inertia 
sT= 0                       % static (or supplimentary) component torque

% mech. transmission parameters
i=6.25, eta=0.95            % multiplication ratio and efficiency
ks =0, ds =0                % stiffness and damping
Jd_l = 0.02, Jd_h = 0.005   % supplimentary inertias of transmission

% SCIG parameters
% 220V / 50Hz
% 157 rad/s
% 6kW
% ____________________________
Rs = 1.265, Rr = 1.430      % stator & rotor resistance, inductance etc
Ls = 0.1452, Lr = 0.1452
Lm = 0.1397, p = 2
sgm=1-Lm^2/Lr/Ls, Tr=Lr/Rr
emTmax = 50                 % maximum torque value
% not used in this application
Jg = 0.01                   % IM inertia

% control law parameters
Jt= (Jwt+Jd_l)/(i*i)+Jd_h+Jg  % high speed shaft inertia = HSS, approx 0.092
tg  = 0.02                    % electromagnetic subsystem (EMS) time constant                   
Tf  = 0.1                     % constant related to the speed derivative


disp('Parameters loaded!')
