% data file for feedback_lin_ctrl.mdl application
% SI units
clear all;

% loading precomputed wind sequece from 'vntu.mat'  (selection is 4)
load vntu, tt=1:length(vK); tt=tt'; vK=vK';

% PMSG parameters
R=3.3                   % stator resistance, d,q inductances etc...
Ld=41.56*10^(-3)
Lq=Ld
p=3
Fie=.4382               % ... flux value

% load parameters
Rch_init=80             % initial value of chopper equivalent resistance
Lch=0.08                % inductance

% state-space model parameters, defined in chapter 3.6.2, (3.88)   
a1=Ld+Lch
a2=-R/a1
a3=(p*(Lq-Lch))/a1

b1=Lq+Lch
b2=-R/b1
b3=(-p*(Ld+Lch))/b1
b4=(p*Fie)/b1

% wind turbine parameters
ro=1.25                     % air density
Rt=2.5                      % blade length
lam_opt=7                   % optimal ti speed ratio
cp_m=0.47                   % maximum power coefficient
i =7                        % transmission ratio
JHSS=0.0042+2.5/(i^2)       % HSS inertia

% parameters of the polynomial approximation of torque coefficient versus the tip speed, relation (3.82)
alfa1=0.1253;                  
alfa2=-0.0047;
alfa3=-0.0005;

% parameters of the wind torque expression, relation (3.84)
a=0.5*pi*ro;
d1=alfa1*a*Rt^3;               
d2=alfa2*a*Rt^4;
d3=alfa3*a*Rt^5;

% parameter used in the inverse transformation, see (5.37)&(5.38)
d4=p*Fie;                      

% initial values (states variables - X)
v0=7; 
x10=-6.02;
x20=11.09;
x30=137.2;

% new coordinates (Z) state variable initial values
z10=x30;
z20=(d1*v0^2+d2*v0*x30+d3*x30^2-d4*x20);
z30=(1/a1*(x10/x20));

disp('Parameters loaded!')