% data file for robust_QFT_ctrl.mdl application
% SI units
clear all;

% loading precomputed wind sequece from 'vntu.mat'  (selection is 4)
load vntu, tt=1:length(vK); tt=tt'; vK=vK';

% PMSG parameters
R=3.3                   % stator resistance, d,q inductances etc...
Ld=41.56*10^(-3)
Lq=Ld
p=3
Fie=.4382               % ... flux value

% load parameters
Rch_init=80             % initial value of chopper equivalent resistance
Lch=0.08                % inductance

% state-space model parameters, defined in chapter 3.6.2, (3.88)   
a1=Ld+Lch
a2=-R/a1
a3=(p*(Lq-Lch))/a1

b1=Lq+Lch
b2=-R/b1
b3=(-p*(Ld+Lch))/b1
b4=(p*Fie)/b1

% wind turbine parameters
ro=1.25                     % air density
Rt=2.5                      % blade length
lam_opt=7                   % optimal ti speed ratio
cp_m=0.47                   % maximum power coefficient
i =7                        % transmission ratio
JHSS=0.0042+2.5/(i^2)       % HSS inertia

% parameters of the polynomial approximation of torque coefficient versus the tip speed, relation (3.82)
alfa1=0.1253;                  
alfa2=-0.0047;
alfa3=-0.0005;

% parameters of the wind torque expression, relation (3.84)
a=0.5*pi*ro;
d1=alfa1*a*Rt^3;               
d2=alfa2*a*Rt^4;
d3=alfa3*a*Rt^5;

% state-space initial values
x10=-6.02;
x20=11.09;
x30=137.2;


% QFT filters and controllers

% prefilter zone 1, relation (5.56)
denF1=[1 359.6373124753 5478.55154871941];
numF1=[5478.55154871941];

% controller zone 1, relation (5.55)
numG1=[6.8404835742024 564.222573297635 9226.11936246174 42677.9683179747];
denG1=[1 1270.5926557475 6633.77569511233 0];

% prefilter zone 2, relation (5.58)
numF2=252572.455308843;
denF2=[1 405.80078974521 22080.6604485845 252908.989891339];

% controller zone 2, relation (5.57)
numG2=[8332.48330935367 761160.259166628 17845799.1277186 161895801.845567 512213459.585676];
denG2=[1 1507.26101029248 319344.672714311 16819434.0639362 79617407.5952384 0];

disp('Parameters loaded!')