% this program generates the system stochastic I/O discrete model
% variable evolutions are resulting from two actions exerted on the system:
% - excitation poroduced by the turbulence component,
% - small-amplitude pseudorandom variation of the torque reference.
% uses data form iden. mat or iden_witness.mat files

% take matrix y from file:
% y(1,:)- is the time
% y(2,:)- is the electromagnetic torque
% y(3,:)- is the rotational speed
% y(4,:)- is the wind velocity
% y(5,:)- is the tip speed ratio
% y(6,:)- is the probing signal
% y(7,:)- is the power coefficient evolution
% y(8,:)- is the control input derivative
load iden
% ... if problems are experienced: load iden_witness

for i=1:14000
ui(i,1)=y(6,i+500);yi(i,1)=y(3,i+500);ti(i,1)=y(1,i);
end

% plot probing signal and rotational speed evolution:
figure(51);plot(ti,ui,ti,yi);grid

% consider only deviations around the average value:
yi(:,1)=yi(:,1)-mean(yi(:,1));
ui(:,1)=ui(:,1)-mean(ui(:,1));

% create data object used for identification routine
% sample time is Ts=0.01
datf=iddata(yi,ui,0.01);

% estimate the discrete-time model parameters...
% ... using the instrumental variable method
modelf=iv4(datf,'na',3,'nb',3,'nk',1)
