/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#include "sketchpaddata.h"

SketchpadData::SketchpadData()
    : simplePoly()
{
    const Point_E2d topRight    = Point_E2d(512, 384);
    const Point_E2d topLeft     = Point_E2d(128, 384);
    const Point_E2d bottomLeft  = Point_E2d(128,  96);
    const Point_E2d bottomRight = Point_E2d(512,  96);

    top    = Line_E2d(topRight, topLeft);
    left   = Line_E2d(topLeft, bottomLeft);
    bottom = Line_E2d(bottomLeft, bottomRight);
    right  = Line_E2d(bottomRight, topRight);

    clippingPoly.push_back(topRight   );
    clippingPoly.push_back(topLeft    );
    clippingPoly.push_back(bottomLeft );
    clippingPoly.push_back(bottomRight);
}

void 
SketchpadData::drawPolygon() const
{
    GLdraw_E2<MyDouble>::draw_polygon(simplePoly);
}

void
SketchpadData::drawRubberPoly(const Point_E2d& rubberPoint) const
{
    for(unsigned int i = 0; i != simplePoly.size()-1; ++i)
	GLdraw_E2<MyDouble>::draw_segment( simplePoly[i], simplePoly[i+1] );

    GLdraw_E2<MyDouble>::draw_segment( simplePoly[0], rubberPoint );
    GLdraw_E2<MyDouble>::draw_segment( rubberPoint, simplePoly[simplePoly.size()-1] );
}
void 
SketchpadData::drawClippingPoly() const
{
    GLdraw_E2<MyDouble>::draw_polygon(clippingPoly, GlowColor::red, GlowColor::red);
}
