/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef SKETCHPADDATA_H
#define SKETCHPADDATA_H

#include <vector>
using std::vector;
#include "geom_types.h"
#include "gldraw_e2.h"

class SketchpadData
{
    vector<Point_E2d> simplePoly;
    vector<Point_E2d> clippingPoly;

    Line_E2d top, left, bottom, right;
public:
    SketchpadData();

    void clear() { simplePoly.clear(); }
    void insertPoint( Point_E2d p) { simplePoly.push_back(p); }

    void drawPolygon() const;
    void drawRubberPoly(const Point_E2d& rubberPoint) const;
    void drawClippingPoly() const;
};

#endif // SKETCHPADDATA_H
