/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef OFFVIEWDATAVIEWER_H
#define OFFVIEWDATAVIEWER_H

#include <string>
#include <algorithm>
using namespace std;

#include "glow.h"
using namespace glow;

#include "point_e3.h"
#include "vector_e3.h"
#include "direction_e3.h"
#include "bbox_e3.h"

typedef double                           myDouble;

typedef Point_E3<myDouble>                Point_3;
typedef Vector_E3<myDouble>              Vector_3;
typedef Direction_E3<myDouble>        Direction_3;

typedef Bbox_E3<myDouble>                  Bbox_3;

#include "color_3.h"
typedef Color_3<float>                   Color_3f;

#include "heds.h"
#include "heds_reader.h"
typedef HEDS<myDouble, Color_3f>              HEDS_ff;
typedef HEDS_reader<myDouble, Color_3f> myHEDS_reader;

typedef Halfedge<myDouble, Color_3f>       myHalfedge;

class OffviewDataViewer : public GlowComponent
{
    HEDS_ff myHEDS;
public:
    OffviewDataViewer(const string& filename,
		      GlowComponent* parent);
private:
    void initLight (void);
    void initCamera (void);
protected:

    virtual void OnEndPaint();

    void drawFilled(GLenum mode);
    void drawWireframe( /*GLenum mode*/ );
    void drawFilledAndWireframe(GLenum mode);

    void draw_polyhedron(bool usePolyColors, GLenum mode);

    void processNearestHit(GLint hits, GLuint selectBuf[]);

public:

    void pickPolygon(int x, int y);

    void extrude_faces();
    void extrude_drag(float current_y, float starting_y);

private:
    Point_3 eye, cnt;

    double maxSpan;

    vector<unsigned int> selected_faces;
};

#endif // OFFVIEWDATAVIEWER_H
