/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef INTERPOLATION_E1_H
#define INTERPOLATION_E1_H

#include "point_e1.h"

// keywords: linear interpolation, affine combination

template<typename T>
Point_E1<T>
interpolate(const Point_E1<T>& P0, const Point_E1<T>& P1, const T& t)
{
    return Point_E1<T>(P0 + (P1-P0) * t);
}

#endif // INTERPOLATION_E1_H
