/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef POINT_E1_H
#define POINT_E1_H

#include <iostream>
using std::ostream;
using std::istream;

template<typename T>
class Point_E1;

template<typename T>
ostream& operator<< (ostream& os, const Point_E1<T>& p);

template<typename T>
istream& operator>> (istream& is, Point_E1<T>& p);

template<typename T>
class Point_E1
{
private:
    T _x;
public:
    Point_E1(const T& x=0) : _x(x) {}

    T x() const { return _x; }

    bool operator==(const Point_E1<T>& p) const {
	return (this == &p) ||
	    (_x == p._x);
    }
    bool operator!=(const Point_E1<T>& p) const {
	return !operator==(p);
    }

    friend ostream& operator<< <>(ostream& os, const Point_E1<T>& p);

    friend istream& operator>> <>(istream& is, Point_E1<T>& p);
};

template<typename T>
ostream& operator<< (ostream& os, const Point_E1<T>& p)
{
    return os << p._x;
}

template<typename T>
istream& operator>> (istream& is, Point_E1<T>& p)
{
    return is >> p._x;
}

#endif // POINT_E1_H
