/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef INTERPOLATION_E2_H
#define INTERPOLATION_E2_H

#include "point_e2.h"
#include "vector_e2.h"

template<typename T>
Point_E2<T>
affine_combination(const Point_E2<T>& P0, const Point_E2<T>& P1, const T& t)
{
    return Point_E2<T>(P0 + (P1-P0) * t);
}

#endif // INTERPOLATION_E2_H
