/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef POLYGON_E2_H
#define POLYGON_E2_H

#include <vector>
using std::vector;
#include "point_e2.h"

template<typename T>
struct Polygon_E2
{
    vector<Point_E2<T> > vertices;

    Polygon_E2() : vertices() {}

    void clear()
    {
	vertices.clear();
    }

    bool isEmpty() const { return !vertices.size(); }

    void insert(const Point_E2<T>& p)
    {
	vertices.push_back(p);
    }

    void getBbox(Point_E2<T>& boxmin, Point_E2<T>& boxmax)
    {
	// precondition: polygon has at least one vertex
	boxmin = boxmax = vertices[0];
	for(unsigned int i=1; i<vertices.size(); ++i) {
	    if(vertices[i].x() < boxmin.x())
		boxmin = Point_E2<T>(vertices[i].x(), boxmin.y());
	    if(vertices[i].y() < boxmin.y())
		boxmin = Point_E2<T>(boxmin.x(), vertices[i].y());
	    if(vertices[i].x() > boxmax.x())
		boxmax = Point_E2<T>(vertices[i].x(), boxmax.y());
	    if(vertices[i].y() > boxmax.y())
		boxmax = Point_E2<T>(boxmax.x(), vertices[i].y());
	}
    }
};

#endif // POLYGON_E2_H
