/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef SEGMENT_E2_H
#define SEGMENT_E2_H

#include "point_e2.h"
#include "vector_e2.h"

template<typename T>
class Segment_E2;

template<typename T>
ostream& operator<<(ostream& os, const Segment_E2<T>& seg);

template<typename T>
class Segment_E2
{
private:
    Point_E2<T> src;		// first or source point of line segment
    Point_E2<T> tgt;		// second or target point of line segment
public:
    Segment_E2() : src(), tgt() {}

    Segment_E2(const Point_E2<T>& src, const Point_E2<T>& tgt): src(src), tgt(tgt)
    {}

    const Point_E2<T>& source() const { return src; }
    const Point_E2<T>& target() const { return tgt; }

    Vector_E2<T> get_Vector_E2() const { return tgt - src; }

    bool operator==(const Segment_E2<T>& L) const {
	return (this == &L) ||
	    (src == L.src && tgt == L.tgt);
    }

    bool operator!=(const Segment_E2<T>& L) const {
	return ! operator==(L);
    }

    friend ostream& operator<< <>(ostream& os, const Segment_E2<T>& seg);
};

template<typename T>
ostream& operator<<(ostream& os, const Segment_E2<T>& seg)
{
    return os << seg.src << " <-> " << seg.tgt;
}

#endif // SEGMENT_E2_H
