/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef SEGMENT_E3_H
#define SEGMENT_E3_H

#include "point_e3.h"
#include "line_e3.h"

template<typename T>
class Segment_E3;

template<typename T>
ostream& operator<<(ostream& os, const Segment_E3<T>& seg);

template<typename T>
class Segment_E3
{
private:
    Point_E3<T> src;		// first or source point of line segment
    Point_E3<T> tgt;		// second or target point of line segment
public:
    Segment_E3() : src(), tgt() {}

    Segment_E3(const Point_E3<T>& src, const Point_E3<T>& tgt): src(src), tgt(tgt)
    {}

    const Point_E3<T>& source() const { return src; }
    const Point_E3<T>& target() const { return tgt; }

    Line_E3<T> getLine_E3() const { return Line_E3<T>(src, tgt); }

    friend ostream& operator<< <>(ostream& os, const Segment_E3<T>& seg);
};

template<typename T>
ostream& operator<<(ostream& os, const Segment_E3<T>& seg)
{
    return os << seg.src << "--" << seg.tgt;
}

#endif // SEGMENT_E3_H
