/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef LINE_P2_H
#define LINE_P2_H

#include "point_p2.h"
#include "../misc/determinant.h"

template<typename T>
class Line_P2;

template<typename T>
ostream& operator<<(ostream& os, const Line_P2<T>& seg);

//----------------------------------------------------------------
template<typename T>
class Line_P2
{
private:
    T _X, _Y, _W;		// Xx+Yy+Ww=0
public:
    Line_P2() : _X(1), _Y(0), _W(0) {}
    Line_P2(const Point_P2<T>& source, const Point_P2<T>& target)
    {
	_X = + determinant(source.hy(), source.hw(),  target.hy(), target.hw());
	_Y = - determinant(source.hx(), source.hw(),  target.hx(), target.hw());
	_W = + determinant(source.hx(), source.hy(),  target.hx(), target.hy());
    }

    bool is_incident(const Point_P2<T>& p) const
    {
	return inner_product(_X, _Y, _W,  p.hx(), p.hy(), p.hw()) == 0;
    }

    T X() const { return _X; }
    T Y() const { return _Y; }
    T W() const { return _W; }

    friend ostream& operator<< <>(ostream& os, const Line_P2<T>& seg);
};
//----------------------------------------------------------------

template<typename T>
ostream& operator<<(ostream& os, const Line_P2<T>& L)
{
    return os << L._X << " " << L._Y << " " << L._W << "  ";
}

#endif // LINE_P2_H
