/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef IMAGE_H
#define IMAGE_H

#include <iostream>
#include "array2.h"
#include "../misc/color_4.h"

template<typename PixelType>
class Image
{
protected:
    int _nrows, _ncols;
    Array2<PixelType> H;
public:
    Image() : _nrows(2), _ncols(2), H(_nrows,_ncols,PixelType()) {}
    Image(int nrows, int ncols)
	: _nrows(nrows), _ncols(ncols), H(nrows, ncols) {}

    int nrows() const { return _nrows; }
    int ncols() const { return _ncols; }
    const PixelType& operator()(int row, int col) const
    {
	return H(row,col);
    }
    PixelType& operator()(int row, int col)
    {
	return H(row,col);
    }
};

std::ostream& operator<< (std::ostream& os, const Image<bool>& I);

#endif //IMAGE_H
