/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

typedef double MyDouble;

typedef enum { BA1, BA2, BA3 } My_Boundary_attributes;
typedef enum { IA1, IA2, IA3 } My_Interior_attributes;


#include "../../geometry_E2/point_e2.h"
#include "../../geometry_E2/segment_e2.h"
#include "../../geometry_E2/triangle_e2.h"
#include "../../geometry_E2/bbox_e2.h"
typedef Point_E2<MyDouble>       Point_E2d;
typedef Segment_E2<MyDouble>   Segment_E2d;
typedef Triangle_E2<MyDouble> Triangle_E2d;
typedef Bbox_E2<MyDouble>         Bbox_E2d;


#include "bsp_e2_convex_polygon.h"
#include "bsp_e2_segment.h"
#include "bsp_e2.h"
#include "../bsp_node.h"
//typedef BSP_E2_convex_polygon< MyDouble, My_Boundary_attributes > BSP_E2_convex_polygon_d;
//typedef BSP_E2_segment       < MyDouble, My_Boundary_attributes >        Sub_hyperplane_d;

typedef BSP_E2< MyDouble, My_Boundary_attributes, My_Interior_attributes >       BSP_geometry;
typedef BSP_geometry::BSP_convex_polytope     BSP_E2_convex_polygon_d;
typedef BSP_geometry::Sub_hyperplane                 Sub_hyperplane_d;

typedef BSP_node< BSP_geometry, My_Boundary_attributes, My_Interior_attributes >  BSP_node_E2;

//----------------------------------------------------------------
#include "../../misc/color_3.h"
typedef Color_3<unsigned char> Color;

typedef BSP_E2< MyDouble, Color, int >                BSP_geometry_E2;
typedef BSP_geometry_E2::BSP_convex_polytope  BSP_E2_convex_polygon_d;
typedef BSP_geometry_E2::Sub_hyperplane              BSP_E2_segment_d;
typedef BSP_node< BSP_geometry_E2, Color, int >          BSP_node_E2d;
