/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#include "../geometry_E3/direction_e3.h"

template<typename NumberType, typename FaceType>
struct Halfedge;

template<typename NumberType, typename FaceType>
struct Face
{
    Halfedge<NumberType, FaceType> *e;
    Direction_E3<NumberType> normal;
    FaceType c;			// normal, color, etc..

    Face(Halfedge<NumberType, FaceType>* myedge) : e(myedge), c(0.5,0.5,0.5) {}
    void setFaceType(FaceType& c1) { c = c1;}
    FaceType getFaceType() const { return c; }
};
