#  The following code example is described in the book "Introduction
#  to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
#  
#  Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
#  modified, or republished electronically or in print provided that
#  this copyright notice appears in all copies. This software is
#  provided "as is" without express or implied warranty; not even for
#  merchantability or fitness for a particular purpose.
# Type 'make' while debugging
# Type 'make opt' to generate an optimized (and brief) executable

opt: $(PROG)
dbg: $(PROG)

GLOW_LOC=/usr/local/glow/glow_src/

MYOSTYPE := $(shell uname)

ifeq ($(MYOSTYPE),CYGWIN_NT-5.1)
    GLOW_LOC=/usr/local/GLOW/glow_src
endif

#================================================================
CC = g++
#================================================================
ifeq ($(MYOSTYPE),Linux)
    CFLAGS = -Wall -LANG:std -I$(GLOW_LOC) \
             -DGLOW_PLATFORM_LINUX \
             -DGLOW_PLATFORM_LITTLEENDIAN \
             -c -MMD
    X11LIB=/usr/X11R6/lib
    LDFLAGS += -L$(GLOW_LOC) -Wl,-R$(GLOW_LOC) \
               -L$(X11LIB)  -Wl,-R$(X11LIB) \
               -lglut -lpthread -lGL -lGLU -lXi -lXmu -lX11 -ldl -lm -lstdc++
else
    ifeq ($(MYOSTYPE),CYGWIN_NT-5.1)
        CFLAGS = -Wall -LANG:std -c -MMD
        LDFLAGS += -L$(GLOW_LOC) -Wl,-R$(GLOW_LOC) \
                   -lglut32 -lglu32 -lopengl32
    else
        ifeq ($(MYOSTYPE),Darwin)
            CFLAGS = -Wall -c -MMD -I$(GLOW_LOC)
            LDFLAGS += -framework GLUT -framework OpenGL -framework Foundation \
                       -lstdc++ -lc -lgcc
        endif
    endif
endif
#================================================================
ifeq ($(MAKECMDGOALS),dbg)
    CFLAGS += -ggdb -DGLOW_OPTION_DEBUG
    LDFLAGS += -lglowdebug -L$(GLOW_LOC)
else				# optimized version generated by default
    CFLAGS += -DNODEBUG -DGLOW_OPTION_NODEBUG # -O2 (use on demand)
    LDFLAGS += -lglow -L$(GLOW_LOC)
endif
#================================================================
.C.o:
	$(CC) $(CFLAGS) $<

$(PROG): $(OBJS)
	$(RM) $@
	$(CC) -o $@ $(OBJS) $(LDFLAGS)

.PHONY: opt dbg clean dclean

clean:
	rm -f *.d *.o
dclean: clean
	rm -f $(PROG) $(PROG).exe

-include $(OBJS:.o=.d)
#================================================================
