/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef TRIANGLE_E2_H
#define TRIANGLE_E2_H

#include "point_e2.h"
#include "predicates_e2.h"
#include "../misc/determinant.h"

template<typename T>
class Triangle_E2
{
    Point_E2<T> p0;
    Point_E2<T> p1;
    Point_E2<T> p2;
public:
    Triangle_E2(const Point_E2<T>& q0, const Point_E2<T>& q1, const Point_E2<T>& q2)
    {
	    p0 = q0; p1 = q1; p2 = q2;
    }

    Point_E2<T> P0() const { return p0; }
    Point_E2<T> P1() const { return p1; }
    Point_E2<T> P2() const { return p2; }

    T get_signed_area() const
    {
	T unity(1.0);
	T half(1.0/2.0);
	T area = half * determinant(p0.x(), p0.y(), unity,
				    p1.x(), p1.y(), unity,
				    p2.x(), p2.y(), unity);
	return area;
    }
};

#endif // TRIANGLE_E2_H
