/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef POINT_E3_H
#define POINT_E3_H

#include <iostream>

template<typename T>
class Point_E3;

template<class S>
std::ostream&
operator<<(std::ostream& os, const Point_E3<S>& p);

template<class S>
std::istream&
operator>>(std::istream& is, Point_E3<S>& p);

template<typename T>
class Point_E3
{
    T _x, _y, _z;

public:
    Point_E3() : _x(),_y(),_z() {}
    Point_E3(const T& x, const T& y, const T& z) : _x(x), _y(y), _z(z) {}

    T x() const { return _x; }
    T y() const { return _y; }
    T z() const { return _z; }

    bool operator==(const Point_E3<T>& p) const {
	return (this == &p) ||
	    (_x == p.x()) && (_y == p.y()) && (_z == p.z());
    }

    template<class S>
    friend std::ostream&
    operator<<(std::ostream& os, const Point_E3<S>& p);

    template<class S>
    friend std::istream&
    operator>>(std::istream& is, Point_E3<S>& p);
};

template<class S>
std::ostream&
operator<<(std::ostream& os, const Point_E3<S>& p)
{
    return os << p._x << " " << p._y << " " << p._z;
}

template<class S>
std::istream&
operator>>(std::istream& is, Point_E3<S>& p)
{
    return is >> p._x >> p._y >> p._z;
}

#endif // POINT_E3_H
