/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#ifndef PREDICATES_S2_H
#define PREDICATES_S2_H

#include <iostream>
using namespace std;

#include "point_s2.h"
#include "segment_s2.h"

#include "../misc/orientation.h"
#include "../misc/determinant.h"

//----------------------------------------------------------------
template<typename T>
Oriented_side
oriented_side(
	      const Point_S2<T>& p1,
	      const Point_S2<T>& p2,
	      const Point_S2<T>& p3)
{
    T d = determinant(
		      p1.x(), p1.y(), p1.z(),
		      p2.x(), p2.y(), p2.z(),
		      p3.x(), p3.y(), p3.z());

    return enum_Oriented_side(d);
}
//----------------------------------------------------------------

template<typename T>
Oriented_side
oriented_side(
	      const Circle_S2<T>& circle,
	      const Point_S2<T>& point)
{
    T d = inner_product(circle, point);
    return enum_Oriented_side(d);
}

template<typename T>
Oriented_side
oriented_side(
	      const Segment_S2<T>& segment,
	      const Point_S2<T>& point)
{
    T d = inner_product(segment.get_Circle_S2(), point);
    return enum_Oriented_side(d);
}

template<typename NT>
bool
is_inside(const Triangle_S2<NT>& T,
	  const Point_S2<NT>& P)
{
    Oriented_side o1 = oriented_side(T.P0(), T.P1(), point);
    Oriented_side o2 = oriented_side(T.P1(), T.P2(), point);
    Oriented_side o2 = oriented_side(T.P2(), T.P0(), point);

    return
	o1 != ON_NEGATIVE_SIDE &&
	o2 != ON_NEGATIVE_SIDE &&
	o3 != ON_NEGATIVE_SIDE;
}

#endif // PREDICATES_S2_H
