/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

#include "../geometry_T3/point_T3.h"
#include "../geometry_T3/vector_T3.h"
#include "../geometry_T3/transformation_T3.h"

// srand48(0) must be called explicitly on cygwin before drand48 is used.

template<typename NT>
void
set_to_random( Point_T3<NT>& P )
{
    NT x = static_cast<NT>(drand48());
    NT y = static_cast<NT>(drand48());
    NT z = static_cast<NT>(drand48());
    NT w = static_cast<NT>(1);

    P = Point_T3<NT>(x,y,z,w);
}

template<typename NT>
void
set_to_random( Vector_T3<NT>& V )
{
    NT x = static_cast<NT>(drand48());
    NT y = static_cast<NT>(drand48());
    NT z = static_cast<NT>(drand48());
    NT w = static_cast<NT>(1);

    V = Vector_T3<NT>(x,y,z,w);
}

template<typename NT>
void
set_to_random( Transformation_T3<NT>& T )
{
    NT m00 = static_cast<NT>(drand48());
    NT m01 = static_cast<NT>(drand48());
    NT m02 = static_cast<NT>(drand48());
    NT m03 = static_cast<NT>(drand48());

    NT m10 = static_cast<NT>(drand48());
    NT m11 = static_cast<NT>(drand48());
    NT m12 = static_cast<NT>(drand48());
    NT m13 = static_cast<NT>(drand48());

    NT m20 = static_cast<NT>(drand48());
    NT m21 = static_cast<NT>(drand48());
    NT m22 = static_cast<NT>(drand48());
    NT m23 = static_cast<NT>(drand48());

    NT m30 = static_cast<NT>(drand48());
    NT m31 = static_cast<NT>(drand48());
    NT m32 = static_cast<NT>(drand48());
    NT m33 = static_cast<NT>(drand48());

    T = Transformation_T3<NT>(m00, m01, m02, m03,
			      m10, m11, m12, m13,
			      m20, m21, m22, m23,
			      m30, m31, m32, m33);
}
