/* The following code example is described in the book "Introduction
 * to Geometric Computing" by Sherif Ghali, Springer-Verlag, 2008.
 *
 * Copyright (C) 2008 Sherif Ghali. This code may be freely copied,
 * modified, or republished electronically or in print provided that
 * this copyright notice appears in all copies. This software is
 * provided "as is" without express or implied warranty; not even for
 * merchantability or fitness for a particular purpose.
 */

template<typename NumberType, typename FaceType>
struct Face;

template<typename NumberType, typename FaceType>
struct Halfedge
{
    Vertex<NumberType, FaceType> * source, * target;
    Face<NumberType, FaceType>            * adjFace;
    Halfedge<NumberType, FaceType>   * pred, * succ;
    Halfedge<NumberType, FaceType>           * twin;

    Halfedge(Vertex<NumberType, FaceType> * source,
	     Vertex<NumberType, FaceType> *target)
	: source(source), target(target)
    {}

    Halfedge(Vertex<NumberType, FaceType> * source,
	     Vertex<NumberType, FaceType> * target,
	     Face<NumberType, FaceType> * adjFace)
	: source(source), target(target), adjFace(adjFace)
    {}
};
