load("D:\\IRER\\FFR\\ppr.Rdata")                                     # <==== change 

##############################################################################################
#input ffr, core, noncore, alpha, period=0.1, where to save the approximate ffr #
##############################################################################################
runPPR.dir = "D:\\IRER\\FFR\\runPPR.R"                              #<==== change where the runPPR.R is stored
coreCPIcpiffr.dir = "D:\\IRER\\FFR\\sƧ\\coreCPIcpiffr.txt"     #<==== change where coreCPIcpiffr.txt is stored
period=0.1              # the width of x(core) & y(noncore) 
savedir = "D:\\IRER\\FFR\\"
n.points = 80
theta = 5           

############ adapt runPPR for the address of coreCPIcpiffr.txt 
source(runPPR.dir)                       
result = runPPR(coreCPIcpiffr.dir, savedir)      # then alpha, beta & figure are produced
ffr = result$ffr
core = core
noncore = noncore
alpha = result$alpha 
writeLines(text=sprintf("alpha = %f  %f", alpha[1], alpha[2]), con=sprintf("%s alpha.txt", savedir))             
z = alpha[1]*core + alpha[2]*noncore
write.csv(data.frame(z=z, ffr=ffr), file=sprintf("%s FFR v.s. z.csv", savedir),row.names =F) 

##############################################################
##############   computatoin of interpolation   ############## 
##############################################################
#rankFFR = as.numeric(rank(ffr, tie="first"))  #? # permute ffr, core, and noncore by the rank of ffr
#ffr[rankFFR] = ffr                            #?   
#core[rankFFR] = core                          #?
#noncore[rankFFR] = noncore                    #?
#z[rankFFR] = z                                #?


approxX = seq(min(core), max(core), by=period)
approxY = seq(min(noncore), max(noncore), by=period)
approxZ = cbind(rep(approxX, each=length(approxY)), rep(approxY, length(approxX))) %*% alpha

approxFFR = rep(NA, length(approxZ))

for(i in 1:length(approxZ)) {      # computing approximate ffr
   if(approxZ[i] > max(z) | approxZ[i] < min(z)) next

   #m1 = which.min( abs(approxZ[i] - z) )
   #m2 = which.min( abs(approxZ[i] - z[-m1]) )   
   #if(m1 < m2) m2 = m2+1
   m1 = which(approxZ[i] - z >= 0)
   m1 = m1[which.min(approxZ[i] - z[m1] )]

   m2 = which(approxZ[i] - z <= 0)
   m2 = m2[which.min(z[m2] - approxZ[i])]
   
   if(z[m1] == z[m2]) M = 0  else  M = (ffr[m1] - ffr[m2])/(z[m1] - z[m2])    # M is the slope of the approximation line
   b = ffr[m1] - M*z[m1]                                                      # b is the intercept of the approximation line
   approxFFR[i] = M*approxZ[i] + b
}
write.csv(data.frame(approxCore=rep(approxX, each=length(approxY)), approxNoncore=rep(approxY, length(approxX)), approxFFR=approxFFR), 
          file=sprintf("%s approximate FFR.csv", savedir),row.names =F) 

##############################################################
############   computatoin of approxiamte slope   ############ 
##############################################################
r = rank(z, ties.method= "first")
z[r] = z
ffr[r] = ffr

approx.slope = rep(NA, floor(length(z)/n.points))
for(i in 1:floor(length(z)/n.points))  
  approx.slope[i] = lm(ffr[1:(i*n.points)]~ z[1:(i*n.points)])$coefficients[2]

N = which(diff(approx.slope) >= (theta/180*pi))      # assume that the figure of ffr v.s. z is nondecreasing
if(length(N) == 0) N = length(approx.slope)-1    else N = max(N)
m = mean(approx.slope[1:N])

x1 = min(z)
y1 = ffr[which.min(z)]
x2 = max(z)
y2 = m*(max(z)-min(z)) + ffr[which.min(z)]

png(filename = sprintf("%s Figure about slope, FFR.jpg", savedir), width =1280, height = 800)
plot(z, ffr)
legend("bottomright", sprintf("The slope of the approximate line is %f", m), cex=2, inset = .05)
lines(c(x1, x2), c(y1, y2), lwd=2, col="gold")
dev.off()
writeLines(sprintf(" slope = %f \n Two points: (%f, %f), (%f, %f)", m, x1, y1, x2, y2), 
           sprintf("%s slope and points.txt", savedir))













