% Two-dimensional Bermudan max call option pricing.
% Last updated: Nov. 2007 by Shih-Feng Huang
tic;clear;
% Input parameters --------------------------------------------------------
r      = 0.05;        % annual risk-less interest rate
q      = 0.1;         % dividend yield
T      = 1;           % time to maturity
K      = 100;         % strike price
Sigma  = [0.04 0.0;...
          0.0  0.04]; % covariance matrix
delta  = 1/3;         % length of time interval
hh     = floor(T/delta);
deltaX = 0.025;       % the length between two adjacent grids
rho    = 0.3;         % the correlation for Gaussian copula
alpha  = 5;           % the parameter for Clayton copula
%--------------------------------------------------------------------------
% Adjusted parameter: enable the European option derived by the 
%                     proposed scheme approaching to the benchmark
c=0.76;              
%--------------------------------------------------------------------------
% Input model number: 
modelnumber = 1;
% '1' for Gaussian(0) copula
% '2' for Gaussian(rho) copula
% '3' for Clayton(alpha) copula
%--------------------------------------------------------------------------
% Set up the range of the partition region
dd     = 40; 
uu     = 40;
X      = deltaX*(-dd:uu); 
m      = length(X);
region = 1+floor(4*sqrt(Sigma(2,2)*delta)/deltaX);
% The basic matrix for the transition matrix
mu(1) = (r-q-0.5*Sigma(1,1)^2)*delta; 
mu(2) = (r-q-0.5*Sigma(2,2)^2)*delta;
for j = 1:2*region+1 
    j1 = j-region-1;
    for i = 1:2*region+1 
        i1  = i-region-1;
        d1u = (i1*deltaX+c*deltaX-mu(1))/sqrt(Sigma(1,1))/sqrt(delta); 
        d1d = (i1*deltaX-(1-c)*deltaX-mu(1))/sqrt(Sigma(1,1))/sqrt(delta); 
        d2u = (j1*deltaX+c*deltaX-mu(2))/sqrt(Sigma(2,2))/sqrt(delta); 
        d2d = (j1*deltaX-(1-c)*deltaX-mu(2))/sqrt(Sigma(2,2))/sqrt(delta);        
        if modelnumber == 1 % Gaussian(0)
           B(j,i) = (normcdf(d1u)-normcdf(d1d))*(normcdf(d2u)-normcdf(d2d));  
        elseif modelnumber == 2 % Gaussian(rho)     
           B(j,i) = dblquad(@XFGBN_3,d1d,d1u,d2d,d2u);
        elseif modelnumber == 3 % Clayton(alpha)
           v1u = normcdf(d1u); 
           v1d = normcdf(d1d); 
           v2u = normcdf(d2u); 
           v2d = normcdf(d2d);
           B(j,i) = max(0,(v1u^(-alpha)+v2u^(-alpha)-1)^(-1/alpha))-...
                    max(0,(v1d^(-alpha)+v2u^(-alpha)-1)^(-1/alpha))-...
                    max(0,(v1u^(-alpha)+v2d^(-alpha)-1)^(-1/alpha))+...
                    max(0,(v1d^(-alpha)+v2d^(-alpha)-1)^(-1/alpha));
        end
    end
end
%--------------------------------------------------------------------------
% The proposed scheme
for j = 1:m 
    for i = 1:m 
        f0(i+(j-1)*m,1) = K*max(0,-1+max([exp(X(i)),exp(X(j))])); % payoff
        g0(i+(j-1)*m,1) = f0(i+(j-1)*m,1);
    end
end
for h = 1:hh     
    for j = 1:m 
        jleft  = max(1,1-j+region+1); 
        jright = min(2*region+1,m-j+region+1); 
        kstar  = max(1,j-region); 
        kend   = kstar+jright-jleft;
        for i = 1:m 
            ileft  = max(1,1-i+region+1); 
            iright = min(2*region+1,m-i+region+1); 
            fstar  = max(1,i-region); 
            fend   = fstar+iright-ileft;
            CC = 0;
            DD = 0;
            for k = kstar:kend
                CC = CC+B(region+1-j+k,ileft:iright)*f0(fstar+(k-1)*m:fend+(k-1)*m,1);
                DD = DD+B(region+1-j+k,ileft:iright)*g0(fstar+(k-1)*m:fend+(k-1)*m,1);
            end
            % European
            f1(i+(j-1)*m,1) = exp(-r*delta)*CC;
            % Bermudan
            g1(i+(j-1)*m,1) = max(K*(-1+max([exp(X(i)),exp(X(j))])),exp(-r*delta)*DD);
        end
    end
    f0 = f1;
    g0 = g1;
    % Results
    y = dd+1;
    [h f0((m+1)*(y-1)+1) g0((m+1)*(y-1)+1)]
end
%-------------------------------
toc;