% One-dimensional Bermudan put option pricing.
% Last updated: Nov. 2007 by Shih-Feng Huang 
tic; clear;
% Input parameters --------------------------------------------------------
r      = 0.08;           % annual risk-less interest rate
q      = 0.12;           % dividend yield 
sigmaS = 0.2;            % annual volatility
delta  = 1/52;           % length of time interval
T      = 3;              % time to maturity 
n      = floor(T/delta); % number of discrete time periods 
S0     = 100;            % initial stock price 
X0     = log(S0); 
K      = 100;            % strike price
N      = 401;            % number of pre-chosen grid points 
mu     = r-q-0.5*sigmaS^2;
%--------------------------------------------------------------------------
% Adjusted parameter: enable the European option derived by the 
%                     proposed scheme approaching to the benchmark
c = 0.49965;     
%--------------------------------------------------------------------------
% The proposed scheme
X        = X0+linspace(-5,5,N)*sqrt(T)*sigmaS;
DeltaX   = (X(N)-X(1))/(N-1);
A(1)     = X(1)-(1-c)*DeltaX;
A(2:N+1) = X+c*DeltaX;
AV(:,1)  = max(0,K-exp(X)); % Bermudan put values at time t_n
EV(:,1)  = max(0,K-exp(X)); % European put values at time t_n
for j = 1:N 
    for k = 1:N
        P(k,j) = normcdf((A(j+1)-X(k)-mu*delta)/(sigmaS*sqrt(delta))) -...
                 normcdf((A(j)-X(k)-mu*delta)/(sigmaS*sqrt(delta)));
    end
end
% At time t_{n-1}
for i = 1:length(X)
    [CallPrice, PutPrice] = blsprice( exp(X(i)), K, r, delta, sigmaS, q );
    AV(i,2) = max(K-exp(X(i)),PutPrice); % Bermudan put at time t_{n-1}
    EV(i,2) = PutPrice;
end;
% From time t_{n-2} to t_0
for h = 2:n
    AV(:,h+1) = max(K-exp(X)',exp(-r*delta)*P*AV(:,h));
    EV(:,h+1) = exp(-r*delta)*P*EV(:,h);
end
%--------------------------------------------------------------------------
% European benchmark
[CallPrice, PutPrice] = blsprice( exp(X0), K, r, T, sigmaS, q );
% The difference between the European option price derived by the proposed 
% scheme and the benchmark. If the difference is too large, then adjust the
% constant c till obtaining an acceptable difference.
EV((N+1)/2,n+1)-PutPrice 
%--------------------------------------------------------------------------
% Results
EuroPut = PutPrice;
BermPut = AV((N+1)/2,n+1);
[EuroPut BermPut]
%--------------------------------------------------------------------------
toc;