% Two-dimensional Bermudan geometric mean put option pricing.
% Last updated: Nov. 2007 by Shih-Feng Huang
tic;clear;
% Input parameters --------------------------------------------------------
r      = 0.05;          % annual risk-less interest rate
q      = 0.0;           % dividend yield
T      = 1;             % time to maturity
K      = 100;           % strike price
Sigma  = [0.04 0.0;...
          0.0  0.04];   % covariance matrix
delta  = 1/12;          % length of time interval
hh     = floor(T/delta);
deltaX = 0.025;         % the length between two adjacent grids
rho    = 0.3;           % the correlation for Gaussian copula
alpha  = 5;             % the parameter for Clayton or Gumbel copula
%--------------------------------------------------------------------------
% Adjusted parameter: enable the European option derived by the 
%                     proposed scheme approaching to the benchmark
c = 0.56;            
%--------------------------------------------------------------------------
% Input model number: 
modelnumber = 1;
% '1' for Gaussian(0) copula
% '2' for Gaussian(rho) copula
% '3' for Clayton(alpha) copula
% '4' for Gumbel(alpha) copula
%--------------------------------------------------------------------------
% Set up the range of the partition region
dd     = 50; 
uu     = 30;
X      = deltaX*(-dd:uu); 
m      = length(X);
region = 1+floor(5*sqrt(Sigma(1,1)*delta)/deltaX);
% The basic matrix for the transition matrix
mu(1) = (r-0.5*Sigma(1,1)^2)*delta; 
mu(2) = (r-0.5*Sigma(2,2)^2)*delta;
for j = 1:2*region+1 
    j1 = j-region-1;
    for i = 1:2*region+1 
        i1  = i-region-1;
        d1u = (i1*deltaX+c*deltaX-mu(1))/sqrt(Sigma(1,1))/sqrt(delta); 
        d1d = (i1*deltaX-(1-c)*deltaX-mu(1))/sqrt(Sigma(1,1))/sqrt(delta); 
        d2u = (j1*deltaX+c*deltaX-mu(2))/sqrt(Sigma(2,2))/sqrt(delta); 
        d2d = (j1*deltaX-(1-c)*deltaX-mu(2))/sqrt(Sigma(2,2))/sqrt(delta);     
        if modelnumber == 1 % Gaussian(0)
           B(j,i) = (normcdf(d1u)-normcdf(d1d))*(normcdf(d2u)-normcdf(d2d));  
        elseif modelnumber == 2 % Gussioan(rho)
           B(j,i) = dblquad(@XFGBN_3,d1d,d1u,d2d,d2u);
        elseif modelnumber == 3 % Clayton(alpha)
           v1u = normcdf(d1u); 
           v1d = normcdf(d1d); 
           v2u = normcdf(d2u); 
           v2d = normcdf(d2d);
           B(j,i) = max(0,(v1u^(-alpha)+v2u^(-alpha)-1)^(-1/alpha))-...
                    max(0,(v1d^(-alpha)+v2u^(-alpha)-1)^(-1/alpha))-...
                    max(0,(v1u^(-alpha)+v2d^(-alpha)-1)^(-1/alpha))+...
                    max(0,(v1d^(-alpha)+v2d^(-alpha)-1)^(-1/alpha));
        elseif modelnumber == 4 % Gumbel(alpha)
           v1u = normcdf(d1u); 
           v1d = normcdf(d1d); 
           v2u = normcdf(d2u); 
           v2d = normcdf(d2d);
           B(j,i) = exp(-((-log(v1u))^alpha+(-log(v2u))^alpha)^(1/alpha))-...
                    exp(-((-log(v1d))^alpha+(-log(v2u))^alpha)^(1/alpha))-...
                    exp(-((-log(v1u))^alpha+(-log(v2d))^alpha)^(1/alpha))+...
                    exp(-((-log(v1d))^alpha+(-log(v2d))^alpha)^(1/alpha));
        end
    end
end
%--------------------------------------------------------------------------
% The proposed scheme
sigmaS = sqrt(sum(sum(Sigma)))/length(Sigma);
rtilde = r+sigmaS^2/2-sum(diag(Sigma))/2/length(Sigma);
for j = 1:m 
    for i = 1:m 
        if modelnumber <= 2 % Gussian
        % At time t_{n-1}: need to adjust the discounted factor
           [CallPrice, PutPrice] = ...
            blsprice( (exp(X(i))*exp(X(j)))^(1/2),1,rtilde,delta,sigmaS);
           f0(i+(j-1)*m,1) = K*exp(-(r-rtilde)*delta)*PutPrice;
           %  Bermudan
           g0(i+(j-1)*m,1) = ...
            K*max( 1-exp((X(i)+X(j))/2), exp(-(r-rtilde)*delta)*PutPrice);
        elseif modelnumber >= 3 % Clayton and Gumbel
        % At time t_n
           f0(i+(j-1)*m,1) = K*max(0,1-exp((X(i)+X(j))/2)); %  European
           g0(i+(j-1)*m,1) = f0(i+(j-1)*m,1); %  Bermudan
        end
    end
end
% At other time points
if modelnumber <= 2
   star = 2;
elseif modelnumber >= 3 
   star = 1;
end
for h = star:hh  
    for j = 1:m 
        jleft  = max(1,1-j+region+1);
        jright = min(2*region+1,m-j+region+1);
        kstar  = max(1,j-region);
        kend   = kstar+jright-jleft;
        for i = 1:m 
            ileft  = max(1,1-i+region+1); 
            iright = min(2*region+1,m-i+region+1); 
            fstar  = max(1,i-region); 
            fend   = fstar+iright-ileft;
            CC = 0;
            DD = 0;
            for k = kstar:kend
                CC = CC+B(region+1-j+k,ileft:iright)*...
                        f0(fstar+(k-1)*m:fend+(k-1)*m);
                DD = DD+B(region+1-j+k,ileft:iright)*...
                        g0(fstar+(k-1)*m:fend+(k-1)*m);
            end
            % European  
            fhat(i+(j-1)*m,h) = exp(-r*delta)*CC;
            % Bermudan
            ghat(i+(j-1)*m,h) =...
             max(K*(1-exp((X(i)+X(j))/2)),exp(-r*delta)*DD);
        end
    end
    f0 = fhat(:,h);
    g0 = ghat(:,h);
end
%--------------------------------------------------------------------------
% Results
y = dd+1;
% European
[fhat((m+1)*(y-1)+1,3) fhat((m+1)*(y-1)+1,6) fhat((m+1)*(y-1)+1,hh)]
% Bermudan
[ghat((m+1)*(y-1)+1,3) ghat((m+1)*(y-1)+1,6) ghat((m+1)*(y-1)+1,hh)]
%--------------------------------------------------------------------------
toc;