% Three-dimensional Bermudan geometric mean put option pricing.
% Last updated: Nov. 2007 by Shih-Feng Huang
tic;clear;
% Input parameters --------------------------------------------------------
r      = 0.05;             % annual risk-less interest rate
q      = 0.0;              % dividend yield
T      = 1/2;              % time to maturity
K      = 100;              % strike price
Sigma  = [0.04 0.0  0.0;... 
          0.0  0.04 0.0;...
          0.0  0.0  0.04]; % covariance matrix
delta  = 1/12;             % length of time interval
hh     = floor(T/delta);
deltaX = 0.05;             % the length between two adjacent grids
rho    = 0.3;              % the correlation for Gaussian copula
alpha  = 5;                % the parameter for Clayton copula
%--------------------------------------------------------------------------
% Adjusted parameter: enable the European option derived by the 
%                     proposed scheme approaching to the benchmark
c = 0.523;      
%--------------------------------------------------------------------------
% Input model number: 
modelnumber = 1;
% '1' for Gaussian(0) copula
% '2' for Gaussian(rho) copula
% '3' for Clayton(alpha) copula
%--------------------------------------------------------------------------
% Set up the range of the partition region
dd     = 20; 
uu     = 12;
X      = deltaX*(-dd:uu);
m      = length(X);
region = 1+floor(4*sqrt(Sigma(1,1)*delta)/deltaX);
% The basic matrix for the transition matrix
mu(1) = (r-0.5*Sigma(1,1)^2)*delta; 
mu(2) = (r-0.5*Sigma(2,2)^2)*delta; 
mu(3) = (r-0.5*Sigma(3,3)^2)*delta;
for k = 1:2*region+1 
    k1 = k-region-1;
    for j = 1:2*region+1 
        j1 = j-region-1;
        for i = 1:2*region+1 
            i1  = i-region-1;
            d1u = (i1*deltaX+c*deltaX-mu(1))/sqrt(Sigma(1,1))/sqrt(delta); 
            d1d = (i1*deltaX-(1-c)*deltaX-mu(1))/sqrt(Sigma(1,1))/sqrt(delta); 
            d2u = (j1*deltaX+c*deltaX-mu(2))/sqrt(Sigma(2,2))/sqrt(delta);  
            d2d = (j1*deltaX-(1-c)*deltaX-mu(2))/sqrt(Sigma(2,2))/sqrt(delta); 
            d3u = (k1*deltaX+c*deltaX-mu(3))/sqrt(Sigma(3,3))/sqrt(delta); 
            d3d = (k1*deltaX-(1-c)*deltaX-mu(3))/sqrt(Sigma(3,3))/sqrt(delta);
            if modelnumber == 1 % Gaussian(0)    
               B(j+(k-1)*(2*region+1),i) = (normcdf(d1u)-normcdf(d1d))*...
                                           (normcdf(d2u)-normcdf(d2d))*...
                                           (normcdf(d3u)-normcdf(d3d));  
            elseif modelnumber == 2 % Gussioan(rho)
               B(j+(k-1)*(2*region+1),i) =... 
                XFGMN3(d1d,d1u,d2d,d2u,d3d,d3u,[1 rho rho; rho 1 rho; rho rho 1]);
                                               
            elseif modelnumber == 3 % Clayton(alpha)
               v1u = normcdf(d1u); 
               v1d = normcdf(d1d); 
               v2u = normcdf(d2u); 
               v2d = normcdf(d2d); 
               v3u = normcdf(d3u); 
               v3d = normcdf(d3d);
               B(j+(k-1)*(2*region+1),i)=...
                (v1u^(-alpha)+v2u^(-alpha)+v3u^(-alpha)-2)^(-1/alpha)-...
                (v1u^(-alpha)+v2u^(-alpha)+v3d^(-alpha)-2)^(-1/alpha)-...
                (v1u^(-alpha)+v2d^(-alpha)+v3u^(-alpha)-2)^(-1/alpha)-...
                (v1d^(-alpha)+v2u^(-alpha)+v3u^(-alpha)-2)^(-1/alpha)+...
                (v1u^(-alpha)+v2d^(-alpha)+v3d^(-alpha)-2)^(-1/alpha)+...
                (v1d^(-alpha)+v2u^(-alpha)+v3d^(-alpha)-2)^(-1/alpha)+...
                (v1d^(-alpha)+v2d^(-alpha)+v3u^(-alpha)-2)^(-1/alpha)-...
                (v1d^(-alpha)+v2d^(-alpha)+v3d^(-alpha)-2)^(-1/alpha);
            end
        end
    end
end
%--------------------------------------------------------------------------
% The proposed scheme
sigmaS = sqrt(sum(sum(Sigma)))/length(Sigma);
rtilde = r+sigmaS^2/2-sum(diag(Sigma))/2/length(Sigma);
for k = 1:m 
    for j = 1:m 
        for i = 1:m 
            if modelnumber <= 2 % Gussian
            % At time t_{n-1}
               % European: need to adjust the discounted factor
               [CallPrice, PutPrice] = ...
                blsprice( (exp(X(i)+X(j)+X(k)))^(1/3), 1, rtilde, delta, sigmaS);
               f0(i+(j-1)*m+(k-1)*m^2,1) = K*exp(-(r-rtilde)*delta)*PutPrice;
               %  Bermudan
               g0(i+(j-1)*m+(k-1)*m^2,1) = ...
                K*max( 1-exp((X(i)+X(j)+X(k))/3), exp(-(r-rtilde)*delta)*PutPrice);
            elseif modelnumber == 3 % Clayton
            % At time t_n
               f0(i+(j-1)*m+(k-1)*m^2,1) = K*max(0,1-exp((X(i)+X(j)+X(k))/3));
               g0(i+(j-1)*m+(k-1)*m^2,1) = f0(i+(j-1)*m+(k-1)*m^2,1);
            end
        end
    end
end
toc
% At other time points
if modelnumber <= 2
   star = 2;
elseif modelnumber == 3 
   star = 1;
end
for h = star:hh 
    tic
    for k = 1:m 
        kleft  = max(1,1-k+region+1); 
        kright = min(2*region+1,m-k+region+1); 
        tkstar = max(1,k-region); 
        tkend  = tkstar+kright-kleft;
        for j = 1:m 
            jleft  = max(1,1-j+region+1); 
            jright = min(2*region+1,m-j+region+1); 
            tjstar = max(1,j-region); 
            tjend  = tjstar+jright-jleft; 
            for i = 1:m 
                ileft  = max(1,1-i+region+1); 
                iright = min(2*region+1,m-i+region+1); 
                fstar  = max(1,i-region); 
                fend   = fstar+iright-ileft;
                CC = 0;
                DD = 0;
                for tk = tkstar:tkend 
                    for tj = tjstar:tjend
                        CC = CC+B(region+1-j+tj+(region+1-k+tk-1)*(2*region+1),ileft:iright)*...
                             f0(fstar+(tj-1)*m+(tk-1)*m^2:fend+(tj-1)*m+(tk-1)*m^2);
                        DD = DD+B(region+1-j+tj+(region+1-k+tk-1)*(2*region+1),ileft:iright)*...
                             g0(fstar+(tj-1)*m+(tk-1)*m^2:fend+(tj-1)*m+(tk-1)*m^2);
                    end
                end
                % European
                f1(i+(j-1)*m+(k-1)*m^2,1) = exp(-r*delta)*CC;
                % Bermudan
                g1(i+(j-1)*m+(k-1)*m^2,1) = max(K*(1-exp((X(i)+X(j)+X(k))/3)),exp(-r*delta)*DD);
            end
        end
    end
    f0 = f1;
    g0 = g1;
    y  = dd+1;
    % Results
    [h f0((m^2+m+1)*(y-1)+1) g0((m^2+m+1)*(y-1)+1)]
    toc
end
%--------------------------------------------------------------------------