% This program copmute the Bermudan geomatric mean put option values
% by reducing the n-dimension problem to 1-dimension.
% Last updated: Nov. 2007 by Shih-Feng Huang
tic;clear;
%--------------------------------------------------------------------------
r0    = 0.05;                 % annual risk-less interest rate
q     = 0.0;                  % dividend yield
T     = 1/4;                  % time to maturity 
K     = 100;                  % strike price
delta = 1/12;                 % length of time interval
n     = floor(T/delta);       % number of discrete time periods   
N     = 401;                  % number of pre-chosen grid points
% 2-dim case
S0    = [100 100];            % initial stock price
Sigma = [0.04 0.0; 0.0 0.04]; % covariance matrix
% 3-dim case
%S0    = [100 100 100];        % initial stock price
%Sigma = [0.04 0.012 0.012;...
%         0.012 0.04 0.012;...
%         0.012 0.012 0.04];   % covariance matrix
%--------------------------------------------------------------------------
% Adjusted parameter: enable the European option derived by the 
%                     proposed scheme approaching to the benchmark
c = 0.499;       
%--------------------------------------------------------------------------
% reduced to 1-dim
S0_bar = (prod(S0))^(1/length(S0));
X0     = log(S0_bar);
sigmaS = sqrt(sum(sum(Sigma)))/length(S0);
r      = r0+sigmaS^2/2-sum(diag(Sigma))/2/length(S0);
mu     = r-q-0.5*sigmaS^2;
%--------------------------------------------------------------------------
% The proposed scheme
X        = X0+linspace(-5,5,N)*sqrt(T)*sigmaS;
DeltaX   = (X(N)-X(1))/(N-1);
A(1)     = X(1)-(1-c)*DeltaX;
A(2:N+1) = X+c*DeltaX;
AV(:,1)  = max(0,K-exp(X)); % Bermudan put values at time t_n
EV(:,1)  = max(0,K-exp(X)); % European put values at time t_n
for j = 1:N 
    for k = 1:N
        P(k,j) = normcdf((A(j+1)-X(k)-mu*delta)/(sigmaS*sqrt(delta))) -...
                 normcdf((A(j)-X(k)-mu*delta)/(sigmaS*sqrt(delta)));
    end
end
% At time t_{n-1}
for i = 1:length(X)
    [CallPrice, PutPrice] = blsprice( exp(X(i)), K, r, delta, sigmaS, q );
    % Bermudan put at time t_{n-1}: need to adjust the discounted factor
    AV(i,2) = max(K-exp(X(i)),exp(-(r0-r)*delta)*PutPrice); 
    % European put at time t_{n-1}: need to adjust the discounted factor
    EV(i,2) = exp(-(r0-r)*delta)*PutPrice;
end;
% From time t_{n-2} to t_0
for h = 2:n
    AV(:,h+1) = max(K-exp(X)',exp(-r0*delta)*P*AV(:,h));
    EV(:,h+1) = exp(-r0*delta)*P*EV(:,h);
end
%--------------------------------------------------------------------------
% European benchmark
[CallPrice, PutPrice] = blsprice( exp(X0), K, r, T, sigmaS, q );
% The difference between the European option price derived by the proposed 
% scheme and the benchmark. If the difference is too large, then adjust the
% constant c till obtaining an acceptable difference.
EV((N+1)/2,n+1)-exp(-(r0-r)*T)*PutPrice 
%--------------------------------------------------------------------------
% Results
EuroPut = exp(-(r0-r)*T)*PutPrice;
BermPut = AV((N+1)/2,n+1);
[EuroPut BermPut] 
%--------------------------------------------------------------------------
toc;