% This function copmutes the European max call values of 2 underlying 
% assets with Gaussian and Clayton copulae by Monte Carlo simulation 
% method.
% Last updated: Nov. 2007 by Shih-Feng Huang
function [Q Qstd] = XFGECmax2MC(S1_0,S2_0, K, r, q, T, sigma1, sigma2)
% Input copula parameter --------------------------------------------------
rho    = 0.3; % the correlation for Gaussian copula
alpha  = 5;   % the parameter for Clayton copula
%--------------------------------------------------------------------------
mu         = [log(S1_0)+(r-q-0.5*sigma1^2)*T;...
              log(S2_0)+(r-q-0.5*sigma2^2)*T];
SigmaT     = sqrt(T)*diag([sigma1 sigma2]);
Cov_matrix = T*[sigma1^2           rho*sigma1*sigma2;...
                rho*sigma1*sigma2  sigma2^2          ];
% Monte Carlo method
rep = 100; 
N   = 100000;
for t = 1:rep
  % Gaussian
    lnST = mvnrnd(mu,Cov_matrix,N)';
  % Clayton
%    lnST = SigmaT*norminv(copularnd('clayton',alpha,N))'+mu*ones(1,N);
    payoff(t) = mean(max(0,-K+exp(max(lnST))));
end
aa = 10;
for t = 1:rep/aa
    Qr(t) = exp(-r*T)*mean(payoff(aa*(t-1)+1:aa*t));
end
% Outputs
Q    = mean(Qr); % the estimated option values
Qstd = std(Qr);  % the standard deviation of the estimate
