% This function copmutes the European geomatric mean put values of 
% 2 underlying assets with Clayton and Gumbel copulae by Monte Carlo 
% simulation method.
% Last updated: Nov. 2007 by Shih-Feng Huang
function [Q Qstd] = XFGEPgmean2MC(S1_0, S2_0, K, r, T, sigma1,sigma2)
% Input copula parameter --------------------------------------------------
alpha  = 5; % the parameter for Clayton or Gumbel copula
%--------------------------------------------------------------------------
mu     = [log(S1_0)+(r-0.5*sigma1^2)*T; log(S2_0)+(r-0.5*sigma2^2)*T];
SigmaT = sqrt(T)*diag([sigma1 sigma2]);
% Monte Carlo method
rep = 400; 
N   = 10000;
for t = 1:rep
   % Clayton
    lnST = SigmaT*norminv(XFGcopularnd('clayton',alpha,N))'+mu*ones(1,N);
   % Gumbel
%    lnST = SigmaT*norminv(XFGcopularnd('gumbel',alpha,N))'+mu*ones(1,N);
    
    payoff(t) = mean(max(0,K-exp(mean(lnST))));
end
aa = 100;
for t = 1:rep/aa
    Qr(t) = exp(-r*T)*mean(payoff(aa*(t-1)+1:aa*t));
end
% Outputs
Q    = mean(Qr); % the estimated option values
Qstd = std(Qr);  % the standard deviation of the estimate