% This function copmutes the European geomatric mean put values of 
% 3 underlying assets with Clayton copula by Monte Carlo simulation method.
% Last updated: Nov. 2007 by Shih-Feng Huang
function [Q Qstd] = XFGEPgmean3MC( S1_0, S2_0, S3_0, K, r, T,...
                                   sigma1, sigma2, sigma3 )
% Input copula parameter --------------------------------------------------
alpha  = 5; % the parameter for Clayton copula
%--------------------------------------------------------------------------
mu     = [log(S1_0)+(r-0.5*sigma1^2)*T;...
          log(S2_0)+(r-0.5*sigma2^2)*T;...
          log(S3_0)+(r-0.5*sigma3^2)*T];
SigmaT = sqrt(T)*diag([sigma1 sigma2 sigma3]);
% Monte Carlo method
rep = 10; 
N   = 1000000;
for t = 1:rep
    lnST   = SigmaT*XFGrClayton_3dim(alpha,N)'+mu*ones(1,N);
    payoff = max(0,K-exp(mean(lnST)));
    Qr(t)  = exp(-r*T)*mean(payoff);
end
% Outputs
Q    = mean(Qr); % the estimated option values
Qstd = std(Qr);  % the standard deviation of the estimate
%==========================================================================
% Generate random numbers from a 3-dimensional Clayton copula by 
% conditional sampling method.
function data = XFGrClayton_3dim(alpha,N)
v = unifrnd(0,1,N,3); 
u_sim(:,1) = v(:,1);
u_sim(:,2) = ( (v(:,1).^(-alpha)).*...
               (v(:,2).^(-alpha/(alpha+1))-1)+1 ).^(-1/alpha);
u_sim(:,3) = ( (u_sim(:,1).^(-alpha)+u_sim(:,2).^(-alpha)-1).*...
               (v(:,3).^(alpha/(-2*alpha-1))-1)+1 ).^(-1/alpha);
data = norminv(u_sim,0,1); % marginal: N(0,1)
