% A function for computing the probability of 3 dimensioanl normal r.v.
% last updated Nov. 2007
% by Shih-Feng Huang
function [F,error,M] = XFGMN3(a1,b1,a2,b2,a3,b3,Sigma)
Nmax = 1000; alpha = 2.5; epsilon = 0.0001; C = chol(Sigma)';
intsum = 0; N = 0; varsum = 0; M=0;
d(1) = normcdf(a1/C(1,1)); e(1) = normcdf(b1/C(1,1)); 
f(1) = e(1)-d(1);
while N < Nmax
      w = unifrnd(0,1,2,1);  
      y(1) = norminv(d(1)+w(1)*(e(1)-d(1)),0,1);
      d(2) = normcdf( (a2-C(2,1)*y(1))/C(2,2) );
      e(2) = normcdf( (b2-C(2,1)*y(1))/C(2,2) );
      f(2) = (e(2)-d(2))*f(1);
      y(2) = norminv(d(2)+w(2)*(e(2)-d(2)),0,1);
      d(3) = normcdf( (a3-C(3,1)*y(1)-C(3,2)*y(2))/C(3,3) );
      e(3) = normcdf( (b3-C(3,1)*y(1)-C(3,2)*y(2))/C(3,3) );
      f(3) = (e(3)-d(3))*f(2);
      intsum = intsum+f(3);
      varsum = varsum+f(3)^2;
      N = N+1;
      if N > 1
         error = alpha*sqrt( (varsum/N-(intsum/N)^2)/N );
      else
         error = epsilon+1;
      end
      if error < epsilon
         M = N;
         N = Nmax;
      end
end
if M == 0
   F = intsum/Nmax;
else
   F = intsum/M;
end