%This code, written by Umberto Cherubini, Sabrina Mulinacci, Silvia
%Romagnoli and Daniela Fenu, computes the distribution of losses for a
%cross section Vasicek model with parameter mu and sigma, and with the
%structure of marginal probability of default p,
%given the structure of temporal correlation (rho), for a particular copula
%function with parameter theta, which represents the temporal dependence (cs=1 for Gumbel, cs=2 for Clayton and cs=3 for Frank)
%and for a number of trials num.

function [bis1_LPM]= Bisezione1_LPM(p,rho,mu,sigma,a,x1,x2,y1,y2,num_it,anno)
for j=1:num_it
            x=(x1+x2)/2;
            y=funz_loss(x,p,rho,mu,sigma,anno)-a;
            if y*y2<=0 
                x1=x;
                y1=y;
            else
                x2=x;
                y2=y;
            end
end
bis1_LPM=x;