%This code, written by Umberto Cherubini, Sabrina Mulinacci, Silvia
%Romagnoli and Daniela Fenu, computes the distribution of losses for a
%cross section Vasicek model with parameter mu and sigma, and with the
%structure of marginal probability of default p,
%given the structure of temporal correlation (rho), for a particular copula
%function with parameter theta, which represents the temporal dependence (cs=1 for Gumbel, cs=2 for Clayton and cs=3 for Frank)
%and for a number of trials num.

function [bis2_LPM]= Bisezione2_LPM(p,rho,mu,sigma,c,x1,x2,y1,y2,num_it,vet,delta_omega,vet_omega,num,gg,theta,cs)
for j=1:num_it
            x=(x1+x2)/2;
            y=nuova_funzLPM(x,vet,p,rho,mu,sigma,c,delta_omega,vet_omega,num,gg,theta,cs);
            if y*y2<0 
                x1=x;
                y1=y;
            elseif y*y2==0 
                x1=x;
                y1=y;
            else    
                x2=x;
                y2=y;
            end
end
bis2_LPM=x;