%This code, written by Umberto Cherubini, Sabrina Mulinacci, Silvia
%Romagnoli and Daniela Fenu, computes the distribution of losses for a
%cross section Vasicek model with parameter mu and sigma, and with the
%structure of marginal probability of default p,
%given the structure of temporal correlation (rho), for a particular copula
%function with parameter theta, which represents the temporal dependence (cs=1 for Clayton, cs=2 for Gumbel and cs=3 for Frank)
%and for a number of trials num.


clear;
theta=1.8603;
p=[0.002566564;0.004381803;0.007262294;0.010817081;0.014407015;0.015674796;0.018283072;0.016908067;0.018614609;0.020142571]
rho=[0.4;0.4;0.4;0.4;0.4;0.4;0.4;0.4;0.4;0.4;0.4;0.4];
mu=0;
sigma=1;
num=1000;
appross=3.0e-08;
delta_omega=1/num;
cs=3;

for n=1:num-1
    a=n*delta_omega;
    x1=0;
    x2=1;
    z=log2((x2-x1)/appross);
    num_it= fix(z)+1;
    y1=funz_loss(x1,p,rho,mu,sigma,1)-a;
    y2=funz_loss(x2,p,rho,mu,sigma,1)-a;
    if y1*y2 <= 0
       x=Bisezione1_LPM(p,rho,mu,sigma,a,x1,x2,y1,y2,num_it,1);
    end
    vet(n,1)=x;
    vet_omega(n)=a;
end

for gg=2 : 10
for t=1:num-1
    c=t*delta_omega;
    x1=0;
    x2=1;
    z=log2((x2-x1)/appross);
    num_it= fix(z)+1;
    y1=nuova_funzLPM(x1,vet,p,rho,mu,sigma,c,delta_omega,vet_omega,num,gg,theta,cs);
    y2=nuova_funzLPM(x2,vet,p,rho,mu,sigma,c,delta_omega,vet_omega,num,gg,theta,cs);
    if y1*y2<=0
        x=Bisezione2_LPM(p,rho,mu,sigma,c,x1,x2,y1,y2,num_it,vet,delta_omega,vet_omega,num,gg,theta,cs);
        vet(t,gg)=x; 
    else   
        ampiezza_int=(x2-x1)/10;
        nuovo_int=0;
        for i=9:1  
            x_int=x1+ampiezza_int*i;
            y_int=nuova_funzLPM(x_int,vet,p,rho,mu,sigma,c,delta_omega,vet_omega,num,gg,theta,cs);
            if y1*y_int<=0
                x2=x_int;
                y2=y_int;
                nuovo_int=1;
            else
                nuovo_int=0;
            end 
        end
        if nuovo_int==1
            x=Bisezione2_LPM(p,rho,mu,sigma,c,x1,x2,y1,y2,num_it,vet,delta_omega,vet_omega,num,gg,theta,cs);
            vet(t,gg)=x; 
        else
            vet(t,gg)=0; 
        end
    end
end
rapp(:,gg-1)=vet(:,gg)./vet(:,1);
end    

