%This code, written by Umberto Cherubini, Sabrina Mulinacci, Silvia
%Romagnoli and Daniela Fenu, computes the distribution of losses for a
%cross section Vasicek model in the year anno, with parameter mu and sigma, and with the
%structure of marginal probability of default p,
%given the structure of temporal correlation (rho).

function [fntv]=funz_loss_vect(x,p,rho,mu,sigma,anno)
b=max(x,0.*x);
fn=(sqrt(1-(rho(anno,1))^2)*norminv(b,mu,sigma)-norminv(p(anno,1),mu,sigma))/rho(anno,1);
fn_loss=normcdf(fn,mu,sigma);
fntv=fn_loss;