%This code, written by Umberto Cherubini, Sabrina Mulinacci, Silvia
%Romagnoli and Daniela Fenu, propagates the distribution of losses in time
%with a choosen copula
%function with parameter theta (cs=1 for Gumbel, cs=2 for Clayton and cs=3
%for Frank) for a
%cross section Vasicek model with parameter mu and sigma, and with the
%structure of marginal probability of default p,
%given the structure of temporal correlation (rho)
%and for a number of trials num.

function [fnt]=nuova_funzLPM(x,vet,p,rho,mu,sigma,c,delta_omega,vet_omega,num,gg,theta,cs)
  somma=0;
  vet_di_uno=ones(1,num-1);
  vettore_di_x=vet_di_uno*x;
  sottr=vettore_di_x-vet(:,gg-1)';
  switch cs
  case{1}
  %Clayton copula
  a=(vet_omega'.^(-theta)+(funz_loss_vect(sottr,p,rho,mu,sigma,gg))'.^(-theta)-1).^(-1/theta);
  index=find(a>0);
  if index>0
  f=((vet_omega(index)'.^(-theta)+(funz_loss_vect(sottr(index),p,rho,mu,sigma,gg))'.^(-theta)-1).^(-(1+theta)/theta).*vet_omega(index)'.^(-(1+theta))).*delta_omega;
  somma=sum(f);
  fn=somma+0.5*delta_omega-c;
  else
  fn=0.5*delta_omega-c;
  end
 
  %Gumbel copula                 
  case{2}
  parte1=(-log(vet_omega)).^(theta)+(-log(funz_loss_vect(sottr,p,rho,mu,sigma,gg))).^(theta);
  f=((exp(-(parte1).^(1/theta)).*((parte1).^((1/theta)-1))).*((-log(vet_omega)).^(theta-1))./vet_omega).*delta_omega;
  somma=sum(f);
  fn=somma+0.5*delta_omega-c;
  
   %Frank copula                 
   case(3)
      
   f=1./(exp(-theta)-1+(exp(-theta.*vet_omega)-1).*(exp(-theta.*(funz_loss_vect(sottr,p,rho,mu,sigma,gg)))-1)).*exp(-theta*vet_omega).*(exp(-theta.*(funz_loss(sottr,p,rho,mu,sigma,gg)))-1).*delta_omega;
  somma=sum(f);
  fn=somma+0.5*delta_omega-c;
                      
          
  end



  
  fnt=fn;