
%This code, written by Umberto Cherubini, Sabrina Mulinacci and Silvia
%Romagnoli, computes the expected value of losses for a specified year (anno), of a tranche defined by
%the Attachement and the Detachement points (respectively Att and Det),
%given the recovery rate (RR), the matrix of the default probabilities
%(mat), and where prob=1/number of trials.

function [EL]=funz_EL(RR,anno,mat,Det,Att,prob)
vet_di_uno=ones(1,size(mat,1));
vet_di_uno=(vet_di_uno)';
  vettore_di_Det=vet_di_uno*Det;
  vettore_di_Att=vet_di_uno*Att;
a=min(mat(:,anno),vettore_di_Det);
b=min(mat(:,anno),vettore_di_Att);
L_a=prob*a;
L_a=sum(L_a);
L_b=prob*b;
L_b=sum(L_b);
EL=(1-RR)*(L_a-L_b);