%trova UF dato R_i
%This code, written by Umberto Cherubini, Sabrina Mulinacci and Silvia
%Romagnoli, computes the up front premium
%(P1) of a tranche defined by
%the Attachement and the Detachement points (respectively Att and Det) for a specified year (anno),
%given the recovery rate (RR), the matrix of the default probabilities
%(mat), the term structure of interest rates (strut), the premium on a
%running basis (RI), paids at the interval (delta) expressed as a part of
%an year and where prob=1/number of trials.

function [P1]=funz_P1(RR,mat,Det,Att,prob,strut,delta,RI,anno)

for k=1:anno
    if k==1
    PN(k,1)=strut(1,1)*funz_EL(RR,1,mat,Det,Att,prob);
    else
   PN(k,1)=strut(1,k)*(funz_EL(RR,k,mat,Det,Att,prob)-funz_EL(RR,k-1,mat,Det,Att,prob));
    end
end

funz_PN=[PN(:,1)];
PN=sum(funz_PN)
for k=1:(delta*anno)
   PD(k,1)=delta*strut(1,k)*(Det-Att-funz_EL(RR,k,mat,Det,Att,prob));
end
funz_PD=[PD(:,1)];
PD=sum(funz_PD)
P1=(PN-RI*PD)/(Det-Att)