% Bivariate copula plots.
% Last updated: Nov. 2007 by Shih-Feng Huang
clear;
rho = 0.5; 
R   = [1 rho; rho 1];
% Monte Carlo method
N = 10000;
% Gaussian
data1 = mvnrnd([0;0],eye(2),N)';
data2 = mvnrnd([0;0],R,N)';
% Clayton
alpha = 2;
data3 = norminv(XFGcopularnd('clayton',alpha,N))';
% Gumbel
alpha = 2;
data4 = norminv(XFGcopularnd('gumbel',alpha,N))';
% Plots
subplot(2,2,1); plot(data1(1,:),data1(2,:),'.')
title('Gaussian ( 0 )');
subplot(2,2,2); plot(data2(1,:),data2(2,:),'.')
title('Gaussian ( 0.5 )');
subplot(2,2,3); plot(data3(1,:),data3(2,:),'.')
title('Clayton ( 2 )');
subplot(2,2,4); plot(data4(1,:),data4(2,:),'.')
title('Gumbel ( 2 )');