% 55-000-0032-20080215-0001
% data and plot Figure for IRER paper 20070822
% Data : XFGinflation
%        QGdpDef : [T GdpDeflator] Quarterly data (1958/03~)
%        PCE : [T PCE] Monthly data (1960/01~)
%        coreCPI : [T coreCPI] Monthly data (1958/01~)
%        Tm : Time Series - Monthly data (1958/01~)
%        mGdpDef : GDP Deflator Monthly Data (generated data) (1958/01~)
%        mPCE : PCE Monthly Data (generated data) (1958/01~)
%        mcoreCPI : coreCPI Monthly Data (1958/01~)

%% 
clear all;
clc;

load XFGinflation
figure1 = figure('PaperType','<custom>','PaperSize',[15 20]);
h=plot(Tm(18:end),[mPCE(18:end) mcoreCPI(18:end) mGdpDef(18:end)],'k');
set(h(1),'LineStyle',':','LineWidth',1)
set(h(2),'LineStyle','-','LineWidth',2)
set(h(3),'LineStyle','-.','LineWidth',2)
xlim([Tm(18) Tm(end)+1040])
set(gca','FontSize',14,'box','off')
Ti=[datenum(1970,1,31) datenum(1980,1,31) datenum(1990,1,31) datenum(2000,1,31)];
set(gca,'xtick',Ti,'xticklabel',{'Jan70','Jan80','Jan90','Jan00'},'XGrid','on')
%	leg=legend('PCE','core CPI','GDP Deflator');
%	set(leg,'EdgeColor',[1 1 1],'box','off');
%	set(gcf,'Position',[1, 1, 1024, 695])
ylabel('%')

set(gcf,'PaperPositionMode','auto')
print -dpng fig1.png
print -dmeta fig1.emf
print -depsc fig1.eps
