

%%
clear all;
clc;

load XFGneutral

a=2.06699727505354;
n=size(Tm,1);
alpha = [0.9592921 0.2824158];
I_PPR=alpha(1)*coreCPI+alpha(2)*(CPI-coreCPI);

figure1 = figure('PaperType','<custom>','PaperSize',[15 20]);
h=plot(Tm,[repmat(a,n,1) pprEstFFR-I_PPR 2+0.5*(mGdpDef-2)],'k');
set(h(1),'linewidth',2)
set(h(2),'linewidth',1)
set(h(3),'linestyle','-.','linewidth',1)

xlim([Tm(1) Tm(end)+1040])
set(gca','FontSize',14,'box','off')
Ti=[datenum(1970,1,31) datenum(1980,1,31) datenum(1990,1,31) datenum(2000,1,31)];
set(gca,'xtick',Ti,'xticklabel',{'Jan70','Jan80','Jan90','Jan00'},'XGrid','on')
%	leg=legend('BLR','PPR','Taylor');
%	set(leg,'EdgeColor',[1 1 1],'box','off');
%	set(gcf,'Position',[1, 1, 1024, 695])
ylabel('%')

set(gcf,'PaperPositionMode','auto')
print -dpng fig9.png
print -dmeta fig9.emf
print -depsc fig9.eps