

%%
clear all;
clc;

load XFGrate
figure1 = figure('PaperType','<custom>','PaperSize',[15 20]);
h=plot(Tm,[FFR coreCPI CPI-coreCPI],'k');
set(h(1),'LineStyle','-','LineWidth',2)
set(h(2),'LineStyle','-.','LineWidth',2)
set(h(3),'LineStyle',':','LineWidth',1)
xlim([Tm(1) Tm(end)+1040])
set(gca','FontSize',14,'box','off')
Ti=[datenum(1970,1,31) datenum(1978,1,31) datenum(1979,7,31) datenum(1987,7,31) datenum(2006,6,31)];
set(gca,'xtick',Ti,'xticklabel',{'70Q1','','79Q3','87Q3','06Q1'},'XGrid','on')
%	leg=legend('FFR','core CPI','non-core CPI');
%	set(leg,'EdgeColor',[1 1 1],'box','off','Position',[0.681 0.7059 0.1455 0.138]);
%	set(gcf,'Position',[1, 1, 1024, 695])
ylabel('%')

annotation(figure1,'textbox','String',{'Martin'},'FontSize',12,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.1865 0.8533 0.04783 0.04317]);

% Create textbox
annotation(figure1,'textbox','String',{'Burns'},'FontSize',12,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.3291 0.8506 0.05466 0.04748]);

% Create textbox
annotation(figure1,'textbox','String',{'Miller'},'FontSize',12,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.418 0.8401 0.05271 0.05657]);

% Create textbox
annotation(figure1,'textbox','String',{'Volcker'},'FontSize',12,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.4893 0.8343 0.05759 0.06465]);

% Create textbox
annotation(figure1,'textbox','String',{'Greenspan'},'FontSize',12,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.6553 0.826 0.09373 0.07475]);

% Create textbox
annotation(figure1,'textbox','String',{'Bernanke'},'FontSize',12,...
    'FitHeightToText','off',...
    'EdgeColor','none',...
    'Position',[0.8438 0.8457 0.07322 0.05455]);



set(gcf,'PaperPositionMode','auto')
print -dpng fig2.png
print -dmeta fig2.emf
print -depsc fig2.eps