% Simulating random path of geometric Brownian motion
% Last updated: Nov. 2007 by Shih-Feng Huang
clear;
% Input parameters --------------------------------------------------------
r      = 0.08; % annual risk-less interest rate
q      = 0.0;  % dividend yield
sigmaS = 0.2;  % annual volatility
S0     = 100;  % initial stock price
K      = 100;  % strike price
T      = 3;    % time to maturity
delta  = 1/52; % length of time interval
n      = floor(T/delta);
%--------------------------------------------------------------------------
x(1:n+1,1) = 0;
x(1)       = log(S0);
dx         = normrnd((r-0.5*sigmaS^2)*delta,sigmaS*sqrt(delta),n,1);
x(2:n+1,1) = x(1)+cumsum(dx);
plot(1:n+1,exp(x))
hold on
plot([1 n],[K K],'r')
hold off